#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// vertical ribbon - Loie FullerMod01.fsh  by   morisil   
//https://www.shadertoy.com/view/NsVGWh
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int   RIBBON_COUNT = 13;
const float RIBBON_WIDTH = .005;
const float RIBBON_EDGE_WIDTH = .003;
const float RIBBON_EDGE_START = RIBBON_WIDTH - RIBBON_EDGE_WIDTH;
const float SCALE_CHANGE = .9;
const float SCALE_CHANGE_VARIATION = .02;
const float SCALE_CHANGE_SPEED = 1.7;
const float WAVE1_PERIOD = 10.;
const float WAVE1_SPEED  = 3.;
const float WAVE1_IMPACT = .05;
const float WAVE2_PERIOD = 8.;
const float WAVE2_SPEED  = 2.5;
const float WAVE2_IMPACT = .2;


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord / iResolution.xy;
    vec2 st =
        (2.* fragCoord - iResolution.xy)
        / min(iResolution.x, iResolution.y);
    vec3 color = vec3(0);
    for (int i = 0; i < RIBBON_COUNT; i++) {
        st *= (
            SCALE_CHANGE
            + (
                sin(iTime * SCALE_CHANGE_SPEED)
                * SCALE_CHANGE_VARIATION
            )
        );
        float dist = length(st);
        float shapeSpace = abs(
            st.x
            + sin(st.y * WAVE1_PERIOD + iTime * WAVE1_SPEED) * WAVE1_IMPACT * (1.2 - uv.y)
            + sin(st.y * WAVE2_PERIOD + iTime * WAVE2_SPEED) * WAVE2_IMPACT * (1.4 - uv.y)
        );
        float ribbon = smoothstep(
            RIBBON_WIDTH,
            RIBBON_EDGE_START,
            shapeSpace
        );
        color += vec3(ribbon);
    }

    fragColor = vec4(color, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

